#include <iostream>
#include <typeinfo>		//Required for RTTI 


//******************************************************************
//***															 ***
//*** to use RTTI in MSVC++ you must use the /GR				 ***
//*** option which is enable through "Project, Settings, C/C++,	 ***
//*** C++ Language, Enable Run-Time Type Identification"		 ***
//*** otherwise you will receive a compiler error				 ***
//***															 ***
//******************************************************************		


using std::cout;
using std::endl;

class Shape {
	virtual void foo() {}
};

class Circle : public Shape {
public:
	void Draw() {cout << "A circle" << endl;}
};

class Square : public Shape {
public:
	void Draw() {cout << "A square" << endl;}
};

void DrawShape(Shape& s)
{
	if(typeid(s).name() == typeid(class Circle).name())
		static_cast<Circle&>(s).Draw();
	else if(typeid(s).name() == typeid(class Square).name())
		static_cast<Square&>(s).Draw();

}

int main()
{
	Circle C1;
	Square S1;

	DrawShape(C1);
	DrawShape(S1);

	return 0;
}