(function(){"use strict";var window=this,document=this.document;function EventEmitter(){this._events=this._events||{}}EventEmitter.prototype.addListener=function(type,listener){this._events[type]=this._events[type]||[];this._events[type].push(listener)};EventEmitter.prototype.on=EventEmitter.prototype.addListener;EventEmitter.prototype.removeListener=function(type,listener){if(!this._events[type])return;var obj=this._events[type],i=obj.length;while(i--){if(obj[i]===listener||obj[i].listener===listener){obj.splice(i,1);return}}};EventEmitter.prototype.off=EventEmitter.prototype.removeListener;EventEmitter.prototype.removeAllListeners=function(type){if(this._events[type])delete this._events[type]};EventEmitter.prototype.once=function(type,listener){function on(){var args=Array.prototype.slice.call(arguments);this.removeListener(type,on);return listener.apply(this,args)}on.listener=listener;return this.on(type,on)};EventEmitter.prototype.emit=function(type){if(!this._events[type])return;var args=Array.prototype.slice.call(arguments,1),obj=this._events[type],l=obj.length,i=0;for(;i<l;i++){obj[i].apply(this,args)}};EventEmitter.prototype.listeners=function(type){return this._events[type]=this._events[type]||[]};var normal=0,escaped=1,csi=2,osc=3,charset=4,dcs=5,ignore=6;function Terminal(cols,rows,handler){EventEmitter.call(this);var options;if(typeof cols==="object"){options=cols;cols=options.cols;rows=options.rows;handler=options.handler}this._options=options||{};this.cols=cols||Terminal.geometry[0];this.rows=rows||Terminal.geometry[1];if(handler){this.on("data",handler)}this.ybase=0;this.ydisp=0;this.x=0;this.y=0;this.cursorState=0;this.cursorHidden=false;this.convertEol=false;this.state=0;this.queue="";this.scrollTop=0;this.scrollBottom=this.rows-1;this.applicationKeypad=false;this.originMode=false;this.insertMode=false;this.wraparoundMode=false;this.normal=null;this.charset=null;this.gcharset=null;this.glevel=0;this.charsets=[null];this.decLocator;this.x10Mouse;this.vt200Mouse;this.vt300Mouse;this.normalMouse;this.mouseEvents;this.sendFocus;this.utfMouse;this.sgrMouse;this.urxvtMouse;this.element;this.children;this.refreshStart;this.refreshEnd;this.savedX;this.savedY;this.savedCols;this.readable=true;this.writable=true;this.defAttr=257<<9|256;this.curAttr=this.defAttr;this.params=[];this.currentParam=0;this.prefix="";this.postfix="";this.lines=[];var i=this.rows;while(i--){this.lines.push(this.blankLine())}this.tabs;this.setupStops()}inherits(Terminal,EventEmitter);Terminal.colors=["#000000","#cc0000","#4e9a06","#c4a000","#3465a4","#75507b","#06989a","#d3d7cf","#555753","#ef2929","#8ae234","#fce94f","#729fcf","#ad7fa8","#34e2e2","#ffffff"];Terminal.colors=function(){var colors=Terminal.colors,r=[0,95,135,175,215,255],i;i=0;for(;i<216;i++){out(r[i/36%6|0],r[i/6%6|0],r[i%6])}i=0;for(;i<24;i++){r=8+i*10;out(r,r,r)}function out(r,g,b){colors.push("#"+hex(r)+hex(g)+hex(b))}function hex(c){c=c.toString(16);return c.length<2?"0"+c:c}return colors}();Terminal.defaultColors={bg:Terminal.colors[15],fg:Terminal.colors[0]};Terminal.colors[256]=Terminal.defaultColors.bg;Terminal.colors[257]=Terminal.defaultColors.fg;Terminal.termName="xterm";Terminal.geometry=[80,24];Terminal.cursorBlink=false;Terminal.visualBell=false;Terminal.popOnBell=false;Terminal.scrollback=1e3;Terminal.screenKeys=false;Terminal.programFeatures=false;Terminal.debug=false;Terminal.focus=null;Terminal.prototype.blur=function(){if(Terminal.focus!==this)return;if(Terminal.focus){Terminal.focus.cursorState=0;Terminal.focus.refresh(Terminal.focus.y,Terminal.focus.y);if(Terminal.focus.sendFocus)Terminal.focus.send("[O")}Terminal.focus=undefined};Terminal.prototype.focus=function(){if(Terminal.focus===this)return;if(Terminal.focus){Terminal.focus.cursorState=0;Terminal.focus.refresh(Terminal.focus.y,Terminal.focus.y);if(Terminal.focus.sendFocus)Terminal.focus.send("[O")}Terminal.focus=this;if(this.sendFocus)this.send("[I");this.showCursor()};function getSelectionHtml(){var html="";if(typeof window.getSelection!="undefined"){var sel=window.getSelection();if(sel.rangeCount){var container=document.createElement("div");for(var i=0,len=sel.rangeCount;i<len;++i){container.appendChild(sel.getRangeAt(i).cloneContents())}html=container.innerHTML}}else if(typeof document.selection!="undefined"){if(document.selection.type=="Text"){html=document.selection.createRange().htmlText}}return html}Terminal.keys_are_bound=false;Terminal.bindKeys=function(client_keydown){if(Terminal.focus)return;if(Terminal.keys_are_bound)return;Terminal.keys_are_bound=true;on(document,"keydown",function(ev){if(typeof Terminal.focus==="undefined"){return}if(typeof client_keydown!="undefined"&&client_keydown(ev)===false){return false}if(ev.metaKey&&isMac){return false}if(!isMac){if(ev.ctrlKey&&ev.keyCode==67&&getSelectionHtml()!=""){return false}if(ev.ctrlKey&&ev.keyCode==86){return false}}if(typeof Terminal.focus==="object"){return Terminal.focus.keyDown(ev)}},true);on(document,"keypress",function(ev){if(typeof Terminal.focus==="undefined"){return}if(typeof Terminal.focus==="object"){return Terminal.focus.keyPress(ev)}},true)};Terminal.prototype.open=function(){var self=this,i=0,div;this.element=document.createElement("div");this.element.className="salvus-console-terminal";this.element.setAttribute("spellcheck","false");this.children=[];for(;i<this.rows;i++){div=document.createElement("div");this.element.appendChild(div);this.children.push(div)}document.body.appendChild(this.element);this.refresh(0,this.rows-1);Terminal.bindKeys(this.client_keydown);this.focus();this.startBlink();on(this.element,"mousedown",function(){self.focus()});on(this.element,"mousedown",function(ev){var button=ev.button!=null?+ev.button:ev.which!=null?ev.which-1:null;if(~navigator.userAgent.indexOf("MSIE")){button=button===1?0:button===4?1:button}if(button!==2)return;self.element.contentEditable="true";setTimeout(function(){self.element.contentEditable="inherit"},1)},true);on(this.element,"paste",function(ev){if(ev.clipboardData){self.send(ev.clipboardData.getData("text/plain"))}else if(window.clipboardData){self.send(window.clipboardData.getData("Text"))}self.element.contentEditable="inherit";return cancel(ev)});this.bindMouse();if(Terminal.brokenBold==null){Terminal.brokenBold=isBoldBroken()}this.element.style.backgroundColor=Terminal.defaultColors.bg;this.element.style.color=Terminal.defaultColors.fg};Terminal.prototype.bindMouse=function(){var el=this.element,self=this,pressed=32;var wheelEvent="onmousewheel"in window?"mousewheel":"DOMMouseScroll";function sendButton(ev){var button,pos;button=getButton(ev);pos=getCoords(ev);if(!pos)return;sendEvent(button,pos);switch(ev.type){case"mousedown":pressed=button;break;case"mouseup":pressed=32;break;case wheelEvent:break}}function sendMove(ev){var button=pressed,pos;pos=getCoords(ev);if(!pos)return;button+=32;sendEvent(button,pos)}function encode(data,ch){if(!self.utfMouse){if(ch===255)return data.push(0);if(ch>127)ch=127;data.push(ch)}else{if(ch===2047)return data.push(0);if(ch<127){data.push(ch)}else{if(ch>2047)ch=2047;data.push(192|ch>>6);data.push(128|ch&63)}}}function sendEvent(button,pos){if(self.vt300Mouse){button&=3;pos.x-=32;pos.y-=32;var data="[24";if(button===0)data+="1";else if(button===1)data+="3";else if(button===2)data+="5";else if(button===3)return;else data+="0";data+="~["+pos.x+","+pos.y+"]\r";self.send(data);return}if(self.decLocator){button&=3;pos.x-=32;pos.y-=32;if(button===0)button=2;else if(button===1)button=4;else if(button===2)button=6;else if(button===3)button=3;self.send("["+button+";"+(button===3?4:0)+";"+pos.y+";"+pos.x+";"+(pos.page||0)+"&w");return}if(self.urxvtMouse){pos.x-=32;pos.y-=32;pos.x++;pos.y++;self.send("["+button+";"+pos.x+";"+pos.y+"M");return}if(self.sgrMouse){pos.x-=32;pos.y-=32;self.send("[<"+((button&3)===3?button&~3:button)+";"+pos.x+";"+pos.y+((button&3)===3?"m":"M"));return}var data=[];encode(data,button);encode(data,pos.x);encode(data,pos.y);self.send("[M"+String.fromCharCode.apply(String,data))}function getButton(ev){var button,shift,meta,ctrl,mod;switch(ev.type){case"mousedown":button=ev.button!=null?+ev.button:ev.which!=null?ev.which-1:null;if(~navigator.userAgent.indexOf("MSIE")){button=button===1?0:button===4?1:button}break;case"mouseup":button=3;break;case"DOMMouseScroll":button=ev.detail<0?64:65;break;case"mousewheel":button=ev.wheelDeltaY>0?64:65;break}shift=ev.shiftKey?4:0;meta=ev.metaKey?8:0;ctrl=ev.ctrlKey?16:0;mod=shift|meta|ctrl;if(self.vt200Mouse){mod&=ctrl}else if(!self.normalMouse){mod=0}button=32+(mod<<2)+button;return button}function getCoords(ev){var x,y,w,h,el;if(ev.pageX==null)return;x=ev.pageX;y=ev.pageY;el=self.element;while(el!==document.documentElement){x-=el.offsetLeft;y-=el.offsetTop;el=el.parentNode}w=self.element.clientWidth;h=self.element.clientHeight;x=x/w*self.cols|0;y=y/h*self.rows|0;if(x<0)x=0;if(x>self.cols)x=self.cols;if(y<0)y=0;if(y>self.rows)y=self.rows;x+=32;y+=32;return{x:x,y:y,down:ev.type==="mousedown",up:ev.type==="mouseup",wheel:ev.type===wheelEvent,move:ev.type==="mousemove"}}on(el,"mousedown",function(ev){if(!self.mouseEvents)return;sendButton(ev);self.focus();if(self.vt200Mouse){sendButton({__proto__:ev,type:"mouseup"});return cancel(ev)}if(self.normalMouse)on(document,"mousemove",sendMove);if(!self.x10Mouse){on(document,"mouseup",function up(ev){sendButton(ev);if(self.normalMouse)off(document,"mousemove",sendMove);off(document,"mouseup",up);return cancel(ev)})}return cancel(ev)});on(el,wheelEvent,function(ev){if(!self.mouseEvents)return;if(self.x10Mouse||self.vt300Mouse||self.decLocator)return;sendButton(ev);return cancel(ev)});on(el,wheelEvent,function(ev){if(self.mouseEvents)return;if(self.applicationKeypad)return;if(ev.type==="DOMMouseScroll"){self.scrollDisp(ev.detail<0?-5:5)}else{self.scrollDisp(ev.wheelDeltaY>0?-5:5)}return cancel(ev)})};Terminal.prototype.destroy=function(){this.readable=false;this.writable=false;this._events={};this.handler=function(){};this.write=function(){}};Terminal.prototype.refresh=function(start,end){if(typeof this.custom_renderer!=="undefined"&&this.custom_renderer!==null){this.custom_renderer(start,end);return}var x,y,i,line,out,ch,width,data,attr,fgColor,bgColor,flags,row,parent;if(end-start>=this.rows/2){parent=this.element.parentNode;if(parent)parent.removeChild(this.element)}width=this.cols;y=start;for(;y<=end;y++){row=y+this.ydisp;if(row>=this.lines.length)break;line=this.lines[row];out="";if(y===this.y&&this.cursorState&&this.ydisp===this.ybase&&!this.cursorHidden){x=this.x}else{x=-1}attr=this.defAttr;i=0;var w=Math.min(width,line.length);for(;i<w;i++){if(!(line[i]!=null)){continue}data=line[i][0];ch=line[i][1];if(i===x)data=-1;if(data!==attr){if(attr!==this.defAttr){out+="</span>"}if(data!==this.defAttr){if(data===-1){out+='<span class="salvus-console-cursor-focus">'}else{out+='<span style="';bgColor=data&511;fgColor=data>>9&511;flags=data>>18;if(flags&1){if(!Terminal.brokenBold){out+="font-weight:bold;"}if(fgColor<8)fgColor+=8}if(flags&2){out+="text-decoration:underline;"}if(bgColor!==256){out+="background-color:"+Terminal.colors[bgColor]+";"}if(fgColor!==257){out+="color:"+Terminal.colors[fgColor]+";"}out+='">'}}}switch(ch){case"&":out+="&amp;";break;case"<":out+="&lt;";break;case">":out+="&gt;";break;default:if(ch<=" "){out+="&nbsp;"}else{out+=ch}break}attr=data}if(attr!==this.defAttr){out+="</span>"}var a=this.children[y];if(a!=null){i=out.length;while(out.slice(i-6,i)==="&nbsp;"){i-=6}out=out.slice(0,i);if(out.length===0){out="&nbsp;"}a.innerHTML=out}}if(parent)parent.appendChild(this.element)};Terminal.prototype.cursorBlink=function(){if(Terminal.focus!==this)return;this.cursorState^=1;this.refresh(this.y,this.y)};Terminal.prototype.showCursor=function(){if(!this.cursorState){this.cursorState=1;this.refresh(this.y,this.y)}else{}};Terminal.prototype.startBlink=function(){if(!Terminal.cursorBlink)return;var self=this;this._blinker=function(){self.cursorBlink()};this._blink=setInterval(this._blinker,500)};Terminal.prototype.refreshBlink=function(){if(!Terminal.cursorBlink)return;clearInterval(this._blink);this._blink=setInterval(this._blinker,500)};Terminal.prototype.scroll=function(){var row;if(++this.ybase===Terminal.scrollback){this.ybase=this.ybase/2|0;this.lines=this.lines.slice(-(this.ybase+this.rows)+1)}this.ydisp=this.ybase;row=this.ybase+this.rows-1;row-=this.rows-1-this.scrollBottom;if(row===this.lines.length){this.lines.push(this.blankLine())}else{this.lines.splice(row,0,this.blankLine())}if(this.scrollTop!==0){if(this.ybase!==0){this.ybase--;this.ydisp=this.ybase}this.lines.splice(this.ybase+this.scrollTop,1)}this.updateRange(this.scrollTop);this.updateRange(this.scrollBottom)};Terminal.prototype.scrollDisp=function(disp){this.ydisp+=disp;if(this.ydisp>this.ybase){this.ydisp=this.ybase}else if(this.ydisp<0){this.ydisp=0}this.emit("scroll",this.ydisp,this.ybase);this.refresh(0,this.rows-1)};Terminal.prototype.setchar=function(x,y,attr,ch){var line=this.lines[y];if(line!=null){line[x]=[attr,ch]}};Terminal.prototype.write=function(data){var l=data.length,i=0,cs,ch;this.refreshStart=this.y;this.refreshEnd=this.y;if(this.ybase!==this.ydisp){this.ydisp=this.ybase;this.maxRange()}for(;i<l;i++){ch=data[i];switch(this.state){case normal:switch(ch){case"":this.bell();break;case"\n":case"":case"\f":if(this.convertEol){this.x=0}this.y++;if(this.y>this.scrollBottom){this.y--;this.scroll()}break;case"\r":this.x=0;break;case"\b":if(this.x>0){this.x--}break;case"	":this.x=this.nextStop();break;case"":this.setgLevel(1);break;case"":this.setgLevel(0);break;case"":this.state=escaped;break;default:if(ch>=" "){if(this.charset&&this.charset[ch]){ch=this.charset[ch]}if(this.x>=this.cols){this.x=0;this.y++;if(this.y>this.scrollBottom){this.y--;this.scroll()}}this.setchar(this.x,this.y+this.ybase,this.curAttr,ch);this.x++;this.updateRange(this.y)}break}break;case escaped:switch(ch){case"[":this.params=[];this.currentParam=0;this.state=csi;break;case"]":this.params=[];this.currentParam=0;this.state=osc;break;case"P":this.params=[];this.currentParam=0;this.state=dcs;break;case"_":this.state=ignore;break;case"^":this.state=ignore;break;case"c":this.reset();break;case"E":this.x=0;case"D":this.index();break;case"M":this.reverseIndex();break;case"%":this.setgLevel(0);this.setgCharset(0,Terminal.charsets.US);this.state=normal;i++;break;case"(":case")":case"*":case"+":case"-":case".":switch(ch){case"(":this.gcharset=0;break;case")":this.gcharset=1;break;case"*":this.gcharset=2;break;case"+":this.gcharset=3;break;case"-":this.gcharset=1;break;case".":this.gcharset=2;break}this.state=charset;break;case"/":this.gcharset=3;this.state=charset;i--;break;case"N":break;case"O":break;case"n":this.setgLevel(2);break;case"o":this.setgLevel(3);break;case"|":this.setgLevel(3);break;case"}":this.setgLevel(2);break;case"~":this.setgLevel(1);break;case"7":this.saveCursor();this.state=normal;break;case"8":this.restoreCursor();this.state=normal;break;case"#":this.state=normal;i++;break;case"H":this.tabSet();break;case"=":this.log("Serial port requested application keypad.");this.applicationKeypad=true;this.state=normal;break;case">":this.log("Switching back to normal keypad.");this.applicationKeypad=false;this.state=normal;break;default:this.state=normal;this.error("Unknown ESC control: %s.",ch);break}break;case charset:switch(ch){case"0":cs=Terminal.charsets.SCLD;break;case"A":cs=Terminal.charsets.UK;break;case"B":cs=Terminal.charsets.US;break;case"4":cs=Terminal.charsets.Dutch;break;case"C":case"5":cs=Terminal.charsets.Finnish;break;case"R":cs=Terminal.charsets.French;break;case"Q":cs=Terminal.charsets.FrenchCanadian;break;case"K":cs=Terminal.charsets.German;break;case"Y":cs=Terminal.charsets.Italian;break;case"E":case"6":cs=Terminal.charsets.NorwegianDanish;break;case"Z":cs=Terminal.charsets.Spanish;break;case"H":case"7":cs=Terminal.charsets.Swedish;break;case"=":cs=Terminal.charsets.Swiss;break;case"/":cs=Terminal.charsets.ISOLatin;i++;break;default:cs=Terminal.charsets.US;break}this.setgCharset(this.gcharset,cs);this.gcharset=null;this.state=normal;break;case osc:if(ch===""||ch===""){if(ch==="")i++;this.params.push(this.currentParam);switch(this.params[0]){case 0:case 1:case 2:if(this.params[1]){this.title=this.params[1];this.handleTitle(this.title)}break;case 3:break;case 4:case 5:break;case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:case 19:break;case 46:break;case 49:if(this.params[1]){this.handleMesg(this.params[1])}break;case 50:break;case 51:break;case 52:break;case 105:case 110:case 111:case 112:case 113:case 114:case 115:case 116:case 117:case 118:break}this.params=[];this.currentParam=0;this.state=normal}else{if(!this.params.length){if(ch>="0"&&ch<="9"){this.currentParam=this.currentParam*10+ch.charCodeAt(0)-48}else if(ch===";"){this.params.push(this.currentParam);this.currentParam=""}}else{this.currentParam+=ch}}break;case csi:if(ch==="?"||ch===">"||ch==="!"){this.prefix=ch;break}if(ch>="0"&&ch<="9"){this.currentParam=this.currentParam*10+ch.charCodeAt(0)-48;break}if(ch==="$"||ch==='"'||ch===" "||ch==="'"){this.postfix=ch;break}this.params.push(this.currentParam);this.currentParam=0;if(ch===";")break;this.state=normal;switch(ch){case"A":this.cursorUp(this.params);break;case"B":this.cursorDown(this.params);break;case"C":this.cursorForward(this.params);break;case"D":this.cursorBackward(this.params);break;case"H":this.cursorPos(this.params);break;case"J":this.eraseInDisplay(this.params);break;case"K":this.eraseInLine(this.params);break;case"m":this.charAttributes(this.params);break;case"n":this.deviceStatus(this.params);break;case"@":this.insertChars(this.params);break;case"E":this.cursorNextLine(this.params);break;case"F":this.cursorPrecedingLine(this.params);break;case"G":this.cursorCharAbsolute(this.params);break;case"L":this.insertLines(this.params);break;case"M":this.deleteLines(this.params);break;case"P":this.deleteChars(this.params);break;case"X":this.eraseChars(this.params);break;case"`":this.charPosAbsolute(this.params);break;case"a":this.HPositionRelative(this.params);break;case"c":this.sendDeviceAttributes(this.params);break;case"d":this.linePosAbsolute(this.params);break;case"e":this.VPositionRelative(this.params);break;case"f":this.HVPosition(this.params);break;case"h":this.setMode(this.params);break;case"l":this.resetMode(this.params);break;case"r":this.setScrollRegion(this.params);break;case"s":this.saveCursor(this.params);break;case"u":this.restoreCursor(this.params);break;case"I":this.cursorForwardTab(this.params);break;case"S":this.scrollUp(this.params);break;case"T":if(this.params.length<2&&!this.prefix){this.scrollDown(this.params)}break;case"Z":this.cursorBackwardTab(this.params);break;case"b":this.repeatPrecedingCharacter(this.params);break;case"g":this.tabClear(this.params);break;case"p":switch(this.prefix){case"!":this.softReset(this.params);break}break;default:this.error("Unknown CSI code: %s.",ch);break}this.prefix="";this.postfix="";break;case dcs:if(ch===""||ch===""){if(ch==="")i++;switch(this.prefix){case"":break;case"$q":var pt=this.currentParam,valid=false;switch(pt){case'"q':pt='0"q';break;case'"p':pt='61"p';break;case"r":pt=""+(this.scrollTop+1)+";"+(this.scrollBottom+1)+"r";break;case"m":pt="0m";break;default:this.error("Unknown DCS Pt: %s.",pt);pt="";break}this.send("P"+ +valid+"$r"+pt+"\\");break;case"+p":break;case"+q":var pt=this.currentParam,valid=false;this.send("P"+ +valid+"+r"+pt+"\\");break;default:this.error("Unknown DCS prefix: %s.",this.prefix);break}this.currentParam=0;this.prefix="";this.state=normal}else if(!this.currentParam){if(!this.prefix&&ch!=="$"&&ch!=="+"){this.currentParam=ch}else if(this.prefix.length===2){this.currentParam=ch}else{this.prefix+=ch}}else{this.currentParam+=ch}break;case ignore:if(ch===""||ch===""){if(ch==="")i++;this.state=normal}break}}this.updateRange(this.y);this.refresh(this.refreshStart,this.refreshEnd)};Terminal.prototype.writeln=function(data){this.write(data+"\r\n")};Terminal.prototype.keyDown=function(ev){var key;switch(ev.keyCode){case 8:if(ev.shiftKey){key="\b";break}key="";break;case 9:if(ev.shiftKey){key="[Z";break}key="	";break;case 13:key="\r";break;case 27:key="";break;case 37:if(this.applicationKeypad){key="OD";break}key="[D";break;case 39:if(this.applicationKeypad){key="OC";break}key="[C";break;case 38:if(this.applicationKeypad){key="OA";break}if(ev.ctrlKey){this.scrollDisp(-1);return cancel(ev)}else{key="[A"}break;case 40:if(this.applicationKeypad){key="OB";break}if(ev.ctrlKey){this.scrollDisp(1);return cancel(ev)}else{key="[B"}break;case 46:key="[3~";break;case 45:key="[2~";break;case 36:if(this.applicationKeypad){key="OH";break}key="OH";break;case 35:if(this.applicationKeypad){key="OF";break}key="OF";break;case 33:if(ev.shiftKey){this.scrollDisp(-(this.rows-1));return cancel(ev)}else{key="[5~"}break;case 34:if(ev.shiftKey){this.scrollDisp(this.rows-1);return cancel(ev)}else{key="[6~"}break;case 112:key="OP";break;case 113:key="OQ";break;case 114:key="OR";break;case 115:key="OS";break;case 116:key="[15~";break;case 117:key="[17~";break;case 118:key="[18~";break;case 119:key="[19~";break;case 120:key="[20~";break;case 121:key="[21~";break;case 122:key="[23~";break;case 123:key="[24~";break;default:if(ev.ctrlKey){if(ev.keyCode>=65&&ev.keyCode<=90){key=String.fromCharCode(ev.keyCode-64)}else if(ev.keyCode===32){key=String.fromCharCode(0)}else if(ev.keyCode>=51&&ev.keyCode<=55){key=String.fromCharCode(ev.keyCode-51+27)}else if(ev.keyCode===56){key=String.fromCharCode(127)}else if(ev.keyCode===219){key=String.fromCharCode(27)}else if(ev.keyCode===221){key=String.fromCharCode(29)}}else if(!isMac&&ev.altKey||isMac&&ev.metaKey){if(ev.keyCode>=65&&ev.keyCode<=90){key=""+String.fromCharCode(ev.keyCode+32)}else if(ev.keyCode===192){key="`"}else if(ev.keyCode>=48&&ev.keyCode<=57){key=""+(ev.keyCode-48)}}break}this.emit("keydown",ev);if(key){this.emit("key",key,ev);this.showCursor();this.handler(key);return cancel(ev)}return true};Terminal.prototype.setgLevel=function(g){this.glevel=g;this.charset=this.charsets[g]};Terminal.prototype.setgCharset=function(g,charset){this.charsets[g]=charset;if(this.glevel===g){this.charset=charset}};Terminal.prototype.keyPress=function(ev){var key;if(ev.charCode){key=ev.charCode}else if(ev.which==null){key=ev.keyCode}else if(ev.which!==0&&ev.charCode!==0){key=ev.which}else{return false}if(!key||ev.ctrlKey||ev.altKey||ev.metaKey)return false;key=String.fromCharCode(key);this.emit("keypress",key,ev);this.emit("key",key,ev);this.showCursor();this.handler(key);return false};Terminal.prototype.send=function(data){var self=this;if(!this.queue){setTimeout(function(){self.handler(self.queue);self.queue=""},50)}this.queue+=data};Terminal.prototype.bell=function(){if(!Terminal.visualBell)return;var self=this;this.element.style.borderColor="white";setTimeout(function(){self.element.style.borderColor=""},10);if(Terminal.popOnBell)this.focus()};Terminal.prototype.log=function(){if(!Terminal.debug)return;if(!window.console||!window.console.log)return;var args=Array.prototype.slice.call(arguments);window.console.log.apply(window.console,args)};Terminal.prototype.error=function(){if(!Terminal.debug)return;if(!window.console||!window.console.error)return;var args=Array.prototype.slice.call(arguments);window.console.error.apply(window.console,args)};Terminal.prototype.resize=function(x,y){var line,el,i,j,ch;if(x<1)x=1;if(y<1)y=1;j=this.cols;if(j<x){ch=[this.defAttr," "];i=this.lines.length;while(i--){while(this.lines[i].length<x){this.lines[i].push(ch)}}}else if(j>x){i=this.lines.length;while(i--){while(this.lines[i].length>x){this.lines[i].pop()}}}this.setupStops(j);this.cols=x;j=this.rows;if(j<y){el=this.element;while(j++<y){if(this.lines.length<y+this.ybase){this.lines.push(this.blankLine())}if(this.children.length<y){line=document.createElement("div");el.appendChild(line);this.children.push(line)}}}else if(j>y){while(j-->y){if(this.lines.length>y+this.ybase){this.lines.pop()}if(this.children.length>y){el=this.children.pop();if(!el)continue;el.parentNode.removeChild(el)}}}this.rows=y;if(this.y>=y)this.y=y-1;if(this.x>=x)this.x=x-1;this.scrollTop=0;this.scrollBottom=y-1;this.refresh(0,this.rows-1);this.normal=null};Terminal.prototype.updateRange=function(y){if(y<this.refreshStart)this.refreshStart=y;if(y>this.refreshEnd)this.refreshEnd=y};Terminal.prototype.maxRange=function(){this.refreshStart=0;this.refreshEnd=this.rows-1};Terminal.prototype.setupStops=function(i){if(i!=null){if(!this.tabs[i]){i=this.prevStop(i)}}else{this.tabs={};i=0}for(;i<this.cols;i+=8){this.tabs[i]=true}};Terminal.prototype.prevStop=function(x){if(x==null)x=this.x;while(!this.tabs[--x]&&x>0);return x>=this.cols?this.cols-1:x<0?0:x};Terminal.prototype.nextStop=function(x){if(x==null)x=this.x;while(!this.tabs[++x]&&x<this.cols);return x>=this.cols?this.cols-1:x<0?0:x};Terminal.prototype.eraseRight=function(x,y){var line=this.lines[this.ybase+y],ch=[this.curAttr," "];if(!(typeof line!=="undefined"&&line!==null)){return}for(;x<this.cols;x++){line[x]=ch}this.updateRange(y)};Terminal.prototype.eraseLeft=function(x,y){var line=this.lines[this.ybase+y],ch=[this.curAttr," "];x++;while(x--)line[x]=ch;this.updateRange(y)};Terminal.prototype.eraseLine=function(y){this.eraseRight(0,y)};Terminal.prototype.blankLine=function(cur){var attr=cur?this.curAttr:this.defAttr;var ch=[attr," "],line=[],i=0;for(;i<this.cols;i++){line[i]=ch}return line};Terminal.prototype.ch=function(cur){return cur?[this.curAttr," "]:[this.defAttr," "]};Terminal.prototype.is=function(term){var name=this.termName||Terminal.termName;return(name+"").indexOf(term)===0};Terminal.prototype.handler=function(data){this.emit("data",data)};Terminal.prototype.handleTitle=function(title){this.emit("title",title)};Terminal.prototype.handleMesg=function(mesg){this.emit("mesg",mesg)};Terminal.prototype.index=function(){this.y++;if(this.y>this.scrollBottom){this.y--;this.scroll()}this.state=normal};Terminal.prototype.reverseIndex=function(){var j;this.y--;if(this.y<this.scrollTop){this.y++;this.lines.splice(this.y+this.ybase,0,this.blankLine(true));j=this.rows-1-this.scrollBottom;this.lines.splice(this.rows-1+this.ybase-j+1,1);this.updateRange(this.scrollTop);this.updateRange(this.scrollBottom)}this.state=normal};Terminal.prototype.reset=function(){Terminal.call(this,this.cols,this.rows);this.refresh(0,this.rows-1)};Terminal.prototype.tabSet=function(){this.tabs[this.x]=true;this.state=normal};Terminal.prototype.cursorUp=function(params){var param=params[0];if(param<1)param=1;this.y-=param;if(this.y<0)this.y=0};Terminal.prototype.cursorDown=function(params){var param=params[0];if(param<1)param=1;this.y+=param;if(this.y>=this.rows){this.y=this.rows-1}};Terminal.prototype.cursorForward=function(params){var param=params[0];if(param<1)param=1;this.x+=param;if(this.x>=this.cols){this.x=this.cols-1}};Terminal.prototype.cursorBackward=function(params){var param=params[0];if(param<1)param=1;this.x-=param;if(this.x<0)this.x=0};Terminal.prototype.cursorPos=function(params){var row,col;row=params[0]-1;if(params.length>=2){col=params[1]-1}else{col=0}if(row<0){row=0}else if(row>=this.rows){row=this.rows-1}if(col<0){col=0}else if(col>=this.cols){col=this.cols-1}this.x=col;this.y=row};Terminal.prototype.eraseInDisplay=function(params){var j;switch(params[0]){case 0:this.eraseRight(this.x,this.y);j=this.y+1;for(;j<this.rows;j++){this.eraseLine(j)}break;case 1:this.eraseLeft(this.x,this.y);j=this.y;while(j--){this.eraseLine(j)}break;case 2:j=this.rows;while(j--)this.eraseLine(j);break;case 3:;break}};Terminal.prototype.eraseInLine=function(params){switch(params[0]){case 0:this.eraseRight(this.x,this.y);break;case 1:this.eraseLeft(this.x,this.y);break;case 2:this.eraseLine(this.y);break}};Terminal.prototype.charAttributes=function(params){var l=params.length,i=0,bg,fg,p;for(;i<l;i++){p=params[i];if(p>=30&&p<=37){this.curAttr=this.curAttr&~(511<<9)|p-30<<9}else if(p>=40&&p<=47){this.curAttr=this.curAttr&~511|p-40}else if(p>=90&&p<=97){p+=8;this.curAttr=this.curAttr&~(511<<9)|p-90<<9}else if(p>=100&&p<=107){p+=8;this.curAttr=this.curAttr&~511|p-100}else if(p===0){this.curAttr=this.defAttr}else if(p===1){this.curAttr=this.curAttr|1<<18}else if(p===4){if(this.prefix===">"){}else{this.curAttr=this.curAttr|2<<18}}else if(p===7||p===27){if(p===7){if(this.curAttr>>18&4)continue;this.curAttr=this.curAttr|4<<18}else if(p===27){if(~(this.curAttr>>18)&4)continue;this.curAttr=this.curAttr&~(4<<18)}bg=this.curAttr&511;fg=this.curAttr>>9&511;this.curAttr=this.curAttr&~262143|(bg<<9|fg)}else if(p===22){this.curAttr=this.curAttr&~(1<<18)}else if(p===24){this.curAttr=this.curAttr&~(2<<18)}else if(p===39){this.curAttr=this.curAttr&~(511<<9);this.curAttr=this.curAttr|(this.defAttr>>9&511)<<9}else if(p===49){this.curAttr=this.curAttr&~511;this.curAttr=this.curAttr|this.defAttr&511}else if(p===38){if(params[i+1]!==5)continue;i+=2;p=params[i]&255;this.curAttr=this.curAttr&~(511<<9)|p<<9}else if(p===48){1;if(params[i+1]!==5)continue;i+=2;p=params[i]&255;this.curAttr=this.curAttr&~511|p}}};Terminal.prototype.deviceStatus=function(params){if(!this.prefix){switch(params[0]){case 5:this.send("[0n");break;case 6:this.send("["+(this.y+1)+";"+(this.x+1)+"R");break}}else if(this.prefix==="?"){switch(params[0]){case 6:this.send("[?"+(this.y+1)+";"+(this.x+1)+"R");break;case 15:break;case 25:break;case 26:break;case 53:break}}};Terminal.prototype.insertChars=function(params){var param,row,j,ch;param=params[0];if(param<1)param=1;row=this.y+this.ybase;j=this.x;ch=[this.curAttr," "];while(param--&&j<this.cols){this.lines[row].splice(j++,0,ch);this.lines[row].pop()}};Terminal.prototype.cursorNextLine=function(params){var param=params[0];if(param<1)param=1;this.y+=param;if(this.y>=this.rows){this.y=this.rows-1}this.x=0};Terminal.prototype.cursorPrecedingLine=function(params){var param=params[0];if(param<1)param=1;this.y-=param;if(this.y<0)this.y=0;this.x=0};Terminal.prototype.cursorCharAbsolute=function(params){var param=params[0];if(param<1)param=1;this.x=param-1};Terminal.prototype.insertLines=function(params){var param,row,j;param=params[0];if(param<1)param=1;row=this.y+this.ybase;j=this.rows-1-this.scrollBottom;j=this.rows-1+this.ybase-j+1;while(param--){this.lines.splice(row,0,this.blankLine(true));this.lines.splice(j,1)}this.updateRange(this.y);this.updateRange(this.scrollBottom)};Terminal.prototype.deleteLines=function(params){var param,row,j;param=params[0];if(param<1)param=1;row=this.y+this.ybase;j=this.rows-1-this.scrollBottom;j=this.rows-1+this.ybase-j;while(param--){this.lines.splice(j+1,0,this.blankLine(true));this.lines.splice(row,1)}this.updateRange(this.y);this.updateRange(this.scrollBottom)};Terminal.prototype.deleteChars=function(params){var param,row,ch;param=params[0];if(param<1)param=1;row=this.y+this.ybase;ch=[this.curAttr," "];while(param--){this.lines[row].splice(this.x,1);this.lines[row].push(ch)}};Terminal.prototype.eraseChars=function(params){var param,row,j,ch;param=params[0];if(param<1)param=1;row=this.y+this.ybase;j=this.x;ch=[this.curAttr," "];while(param--&&j<this.cols){this.lines[row][j++]=ch}};Terminal.prototype.charPosAbsolute=function(params){var param=params[0];if(param<1)param=1;this.x=param-1;if(this.x>=this.cols){this.x=this.cols-1}};Terminal.prototype.HPositionRelative=function(params){var param=params[0];if(param<1)param=1;this.x+=param;if(this.x>=this.cols){this.x=this.cols-1}};Terminal.prototype.sendDeviceAttributes=function(params){if(params[0]>0)return;if(!this.prefix){if(this.is("xterm")||this.is("rxvt-unicode")||this.is("screen")){this.send("[?1;2c")}else if(this.is("linux")){this.send("[?6c")}}else if(this.prefix===">"){if(this.is("xterm")){this.send("[>0;276;0c")}else if(this.is("rxvt-unicode")){this.send("[>85;95;0c")}else if(this.is("linux")){this.send(params[0]+"c")}else if(this.is("screen")){this.send("[>83;40003;0c")}}};Terminal.prototype.linePosAbsolute=function(params){var param=params[0];
if(param<1)param=1;this.y=param-1;if(this.y>=this.rows){this.y=this.rows-1}};Terminal.prototype.VPositionRelative=function(params){var param=params[0];if(param<1)param=1;this.y+=param;if(this.y>=this.rows){this.y=this.rows-1}};Terminal.prototype.HVPosition=function(params){if(params[0]<1)params[0]=1;if(params[1]<1)params[1]=1;this.y=params[0]-1;if(this.y>=this.rows){this.y=this.rows-1}this.x=params[1]-1;if(this.x>=this.cols){this.x=this.cols-1}};Terminal.prototype.setMode=function(params){if(typeof params==="object"){var l=params.length,i=0;for(;i<l;i++){this.setMode(params[i])}return}if(!this.prefix){switch(params){case 4:this.insertMode=true;break;case 20:break}}else if(this.prefix==="?"){switch(params){case 1:this.applicationKeypad=true;break;case 2:this.setgCharset(0,Terminal.charsets.US);this.setgCharset(1,Terminal.charsets.US);this.setgCharset(2,Terminal.charsets.US);this.setgCharset(3,Terminal.charsets.US);break;case 3:this.savedCols=this.cols;this.resize(132,this.rows);break;case 6:this.originMode=true;break;case 7:this.wraparoundMode=true;break;case 12:break;case 9:case 1e3:case 1002:case 1003:this.x10Mouse=params===9;this.vt200Mouse=params===1e3;this.normalMouse=params>1e3;this.mouseEvents=true;this.element.style.cursor="default";this.log("Binding to mouse events.");break;case 1004:this.sendFocus=true;break;case 1005:this.utfMouse=true;break;case 1006:this.sgrMouse=true;break;case 1015:this.urxvtMouse=true;break;case 25:this.cursorHidden=false;break;case 1049:;case 47:case 1047:if(!this.normal){var normal={lines:this.lines,ybase:this.ybase,ydisp:this.ydisp,x:this.x,y:this.y,scrollTop:this.scrollTop,scrollBottom:this.scrollBottom,tabs:this.tabs};this.reset();this.normal=normal;this.showCursor()}break}}};Terminal.prototype.resetMode=function(params){if(typeof params==="object"){var l=params.length,i=0;for(;i<l;i++){this.resetMode(params[i])}return}if(!this.prefix){switch(params){case 4:this.insertMode=false;break;case 20:break}}else if(this.prefix==="?"){switch(params){case 1:this.applicationKeypad=false;break;case 3:if(this.cols===132&&this.savedCols){this.resize(this.savedCols,this.rows)}delete this.savedCols;break;case 6:this.originMode=false;break;case 7:this.wraparoundMode=false;break;case 12:break;case 9:case 1e3:case 1002:case 1003:this.x10Mouse=false;this.vt200Mouse=false;this.normalMouse=false;this.mouseEvents=false;this.element.style.cursor="";break;case 1004:this.sendFocus=false;break;case 1005:this.utfMouse=false;break;case 1006:this.sgrMouse=false;break;case 1015:this.urxvtMouse=false;break;case 25:this.cursorHidden=true;break;case 1049:;case 47:case 1047:if(this.normal){this.lines=this.normal.lines;this.ybase=this.normal.ybase;this.ydisp=this.normal.ydisp;this.x=this.normal.x;this.y=this.normal.y;this.scrollTop=this.normal.scrollTop;this.scrollBottom=this.normal.scrollBottom;this.tabs=this.normal.tabs;this.normal=null;this.refresh(0,this.rows-1);this.showCursor()}break}}};Terminal.prototype.setScrollRegion=function(params){if(this.prefix)return;this.scrollTop=(params[0]||1)-1;this.scrollBottom=(params[1]||this.rows)-1;this.x=0;this.y=0};Terminal.prototype.saveCursor=function(params){this.savedX=this.x;this.savedY=this.y};Terminal.prototype.restoreCursor=function(params){this.x=this.savedX||0;this.y=this.savedY||0};Terminal.prototype.cursorForwardTab=function(params){var param=params[0]||1;while(param--){this.x=this.nextStop()}};Terminal.prototype.scrollUp=function(params){var param=params[0]||1;while(param--){this.lines.splice(this.ybase+this.scrollTop,1);this.lines.splice(this.ybase+this.scrollBottom,0,this.blankLine())}this.updateRange(this.scrollTop);this.updateRange(this.scrollBottom)};Terminal.prototype.scrollDown=function(params){var param=params[0]||1;while(param--){this.lines.splice(this.ybase+this.scrollBottom,1);this.lines.splice(this.ybase+this.scrollTop,0,this.blankLine())}this.updateRange(this.scrollTop);this.updateRange(this.scrollBottom)};Terminal.prototype.initMouseTracking=function(params){};Terminal.prototype.resetTitleModes=function(params){};Terminal.prototype.cursorBackwardTab=function(params){var param=params[0]||1;while(param--){this.x=this.prevStop()}};Terminal.prototype.repeatPrecedingCharacter=function(params){var param=params[0]||1,line=this.lines[this.ybase+this.y],ch=line[this.x-1]||[this.defAttr," "];while(param--)line[this.x++]=ch};Terminal.prototype.tabClear=function(params){var param=params[0];if(param<=0){delete this.tabs[this.x]}else if(param===3){this.tabs={}}};Terminal.prototype.mediaCopy=function(params){};Terminal.prototype.setResources=function(params){};Terminal.prototype.disableModifiers=function(params){};Terminal.prototype.setPointerMode=function(params){};Terminal.prototype.softReset=function(params){this.cursorHidden=false;this.insertMode=false;this.originMode=false;this.wraparoundMode=false;this.applicationKeypad=false;this.scrollTop=0;this.scrollBottom=this.rows-1;this.curAttr=this.defAttr;this.x=this.y=0;this.charset=null;this.glevel=0;this.charsets=[null]};Terminal.prototype.requestAnsiMode=function(params){};Terminal.prototype.requestPrivateMode=function(params){};Terminal.prototype.setConformanceLevel=function(params){};Terminal.prototype.loadLEDs=function(params){};Terminal.prototype.setCursorStyle=function(params){};Terminal.prototype.setCharProtectionAttr=function(params){};Terminal.prototype.restorePrivateValues=function(params){};Terminal.prototype.setAttrInRectangle=function(params){var t=params[0],l=params[1],b=params[2],r=params[3],attr=params[4];var line,i;for(;t<b+1;t++){line=this.lines[this.ybase+t];for(i=l;i<r;i++){line[i]=[attr,line[i][1]]}}this.updateRange(params[0]);this.updateRange(params[2])};Terminal.prototype.savePrivateValues=function(params){};Terminal.prototype.manipulateWindow=function(params){};Terminal.prototype.reverseAttrInRectangle=function(params){};Terminal.prototype.setTitleModeFeature=function(params){};Terminal.prototype.setWarningBellVolume=function(params){};Terminal.prototype.setMarginBellVolume=function(params){};Terminal.prototype.copyRectangle=function(params){};Terminal.prototype.enableFilterRectangle=function(params){};Terminal.prototype.requestParameters=function(params){};Terminal.prototype.selectChangeExtent=function(params){};Terminal.prototype.fillRectangle=function(params){var ch=params[0],t=params[1],l=params[2],b=params[3],r=params[4];var line,i;for(;t<b+1;t++){line=this.lines[this.ybase+t];for(i=l;i<r;i++){line[i]=[line[i][0],String.fromCharCode(ch)]}}this.updateRange(params[1]);this.updateRange(params[3])};Terminal.prototype.enableLocatorReporting=function(params){var val=params[0]>0};Terminal.prototype.eraseRectangle=function(params){var t=params[0],l=params[1],b=params[2],r=params[3];var line,i,ch;ch=[this.curAttr," "];for(;t<b+1;t++){line=this.lines[this.ybase+t];for(i=l;i<r;i++){line[i]=ch}}this.updateRange(params[0]);this.updateRange(params[2])};Terminal.prototype.setLocatorEvents=function(params){};Terminal.prototype.selectiveEraseRectangle=function(params){};Terminal.prototype.requestLocatorPosition=function(params){};Terminal.prototype.insertColumns=function(){var param=params[0],l=this.ybase+this.rows,ch=[this.curAttr," "],i;while(param--){for(i=this.ybase;i<l;i++){this.lines[i].splice(this.x+1,0,ch);this.lines[i].pop()}}this.maxRange()};Terminal.prototype.deleteColumns=function(){var param=params[0],l=this.ybase+this.rows,ch=[this.curAttr," "],i;while(param--){for(i=this.ybase;i<l;i++){this.lines[i].splice(this.x,1);this.lines[i].push(ch)}}this.maxRange()};Terminal.charsets={};Terminal.charsets.SCLD={"`":"◆",a:"▒",b:"	",c:"\f",d:"\r",e:"\n",f:"°",g:"±",h:"␤",i:"",j:"┘",k:"┐",l:"┌",m:"└",n:"┼",o:"⎺",p:"⎻",q:"─",r:"⎼",s:"⎽",t:"├",u:"┤",v:"┴",w:"┬",x:"│",y:"≤",z:"≥","{":"π","|":"≠","}":"£","~":"·"};Terminal.charsets.UK=null;Terminal.charsets.US=null;Terminal.charsets.Dutch=null;Terminal.charsets.Finnish=null;Terminal.charsets.French=null;Terminal.charsets.FrenchCanadian=null;Terminal.charsets.German=null;Terminal.charsets.Italian=null;Terminal.charsets.NorwegianDanish=null;Terminal.charsets.Spanish=null;Terminal.charsets.Swedish=null;Terminal.charsets.Swiss=null;Terminal.charsets.ISOLatin=null;function on(el,type,handler,capture){el.addEventListener(type,handler,capture||false)}function off(el,type,handler,capture){el.removeEventListener(type,handler,capture||false)}function cancel(ev){if(ev.preventDefault)ev.preventDefault();ev.returnValue=false;if(ev.stopPropagation)ev.stopPropagation();ev.cancelBubble=true;return false}function inherits(child,parent){function f(){this.constructor=child}f.prototype=parent.prototype;child.prototype=new f}var isMac=~navigator.userAgent.indexOf("Mac");function isBoldBroken(){var el=document.createElement("span");el.innerHTML="hello world";document.body.appendChild(el);var w1=el.scrollWidth;el.style.fontWeight="bold";var w2=el.scrollWidth;document.body.removeChild(el);return w1!==w2}var String=this.String;var setTimeout=this.setTimeout;var setInterval=this.setInterval;Terminal.EventEmitter=EventEmitter;Terminal.isMac=isMac;Terminal.inherits=inherits;Terminal.on=on;Terminal.off=off;Terminal.cancel=cancel;if(typeof module!=="undefined"){module.exports=Terminal}else{this.Terminal=Terminal}}).call(function(){return this||(typeof window!=="undefined"?window:global)}());