from sympy import IndexedBase, Matrix, Mul, Poly, floor, var, pprint, S
from sympy import rem, prod, degree_list, total_degree, apart, residue, series, together
from sympy import numbered_symbols, take, fps, collect, groebner, Rational
from sympy import sqf, sqf_list, quo, diff, integrate, sqrt, cos, Integral, together, cot, sin
from sympy import numer, denom, gcd, degree
from sympy.series.formal import compute_fps
from sympy.core.compatibility import range
from sympy.polys.monomials import monomial_deg
from sympy.polys.monomials import itermonomials
from sympy.polys.orderings import monomial_key
from sympy.polys.polytools import poly_from_expr
from sympy.functions.combinatorial.factorials import binomial

from itertools import combinations_with_replacement, combinations, product

from sympy import symbols, solve, factor, expand, simplify, nsimplify, solve_undetermined_coeffs

a, b, c, d, w, x, y, z = symbols('a, b, c, d, w, x, y, z')

def int_rat_part_O(p, q, x):
    """
    Input: Polynomials p, q with deg(p) < deg(q).
    Output: (p_1)/(q_1) the rational part of the integral intp/q and (p_2)/(q_2),
    the integrand of the logarithmic (transcendental) part.
    """
    # form q1, q2 and take their degrees 
    q1 = gcd( q, diff(q, x, 1) )
    q2 = quo( q, q1, x )
    dq1 = degree( q1, x )
    dq2 = degree( q2, x )

    # form p1, p2 with undetermined coefficients
    coeffsp1 = take( numbered_symbols(w), dq1 )
    p1 = sum( [coeffsp1[i]*x**i for i in range(dq1)] )
    coeffsp2 = take( numbered_symbols(z), dq2 )
    p2 = sum( [coeffsp2[i]*x**i for i in range(dq2)] )

    # form s, t
    s = quo( diff(q1, x, 1)*q2 , q1, x )
    t = ( diff( p1, x, 1 )*q2 - p1*s + p2*q1
    ).expand().collect(x)

    # solve system to find coefficients of p1, p2
    slts = solve_undetermined_coeffs( t - p, coeffsp1 + coeffsp2, x )

    # form rational part p1 / q1
    if degree(p1, x) > 0:
        p1 = p1.subs(slts)
    rat_part = p1 / q1

    # form log part p2 / q2
    if degree(p2, x) > 0:
        p2 = p2.subs(slts)
    log_part = p2 / q2

    ## simplify numerators, denominators
    temp = together( rat_part )
    temp_num = expand( numer( temp ) )
    temp_den = expand( denom( temp ) )
    rat_part = temp_num / temp_den

    temp1 = together( log_part )
    temp1_num = expand( numer( temp1 ) )
    temp1_den = expand( denom( temp1 ) )
    log_part = temp1_num / temp1_den

    return [rat_part, log_part]

# f = (x**2 - 2) / (x**3 + 3*x**2 + 2*x)
# print('f = ', f, '\n')
"""
print('f @ 0= ', fps(f, x, x0=0).truncate(), '\n')
print('f @ 0 = ', series(f, x, x0=0),'\n')
print('residue = ', residue( f, x, 0),'\n')

print('f @ -1 = ', fps(f, x, x0=-1).truncate(), '\n')
print('f @ -1 = ', series(f, x, x0=-1),'\n')
print('residue = ', residue( f, x, -1),'\n')


print('f @ -2 = ', fps(f, x, x0=-2).truncate(), '\n')
print('f @ -2 = ', series(f, x, x0=-2),'\n')
print('residue = ', residue( f, x, -2),'\n')

print('f = ', simplify(together(apart(f))), '\n')

## Residue computation method 1
print('Residue computation method 1' , '\n')

a0, a1, a2, f, f1, f2, f3, s1, s2, s3 = symbols('a0, a1, a2, f, f1, f2, f3, s1, s2, s3')

print(collect(expand(f1 * (x - s2) * (x - s3) + f2 * (x - s1) * (x - s3) +
       f3 * (x - s1) * (x - s2)), x), '\n')

print(simplify(f * (x + 2)).subs({x : -2}),'\n')

f = 1 / ( x**2 * (x + 1) )
print('f = ', f, '\n')
print('f = ', apart(f), '\n')

print(residue( f, x, 0), '\n')
print(residue( f, x, -1), '\n')

"""

p = 12*x**5 + 8*x**4 + 12*x**3 + 4*x**2 + 4*x + 4
q = x**6 + 2*x**5 + 3*x**4 + 4*x**3 + 3*x**2 + 2*x + 1

print(integrate(p/q, x), '\n')
print(simplify((4*x**2 + 3*x + 5)/(x**3 + x**2 + x + 1) - 1/(5*x - 5)), '\n')

print(int_rat_part_O(p, q, x))
"""
print('p = ', p, '\n')
print('q = ', q, '\n')
print('sqf(q) = ', sqf(q), '\n')
q1 = sqf_list(q)[1][0][0]
print('factor(q1) = ', factor(q1), '\n')
print('sqf_list(q) = q1 = ', q1, '\n')
q2= quo(q, q1)
print('q2 = quo(q, q1) = ', q2, '\n')

w = symbols('w')

coeffs_p1 = take( numbered_symbols(w), 3 )
print('coeffs_p1 = ', coeffs_p1, '\n')

p1 = sum( [coeffs_p1[i]*x**i for i in range(3)] )
print('p1 = ', p1, '\n')

coeffs_p2 = take( numbered_symbols(z), 3 )
print('coeffs_p2 = ', coeffs_p2, '\n')

p2 = sum( [coeffs_p2[i]*x**i for i in range(3)] )
print('p2 = ', p2, '\n')

s = diff( q1, x, 1 ) * q2 / q1
print('s = ', s, '\n')

t = (
    
        diff(p1, x, 1) * q2 - p1 * s + p2 * q1
        
            ).expand().collect(x)

print('t = ', t, '\n')

sols = solve_undetermined_coeffs( t - p, coeffs_p1 + coeffs_p2, x )
print('sols = ', sols, '\n')

p1 = p1.subs(sols)
print('p1 = ', p1, '\n')

p2 = p2.subs(sols)
print('p2 = ', p2, '\n')


print(integrate(sqrt(1 - cos(x)), x), '\n')

print(Integral(sqrt(1 - cos(x)), (x, 0, 6)).doit(), '\n')

print(together(integrate(1 / (x**4 + 1), x)), '\n')

print(cot(x/2).rewrite(sin), '\n')
"""