# -*- coding: utf-8 -*-
"""
Created on Fri Apr  4 23:19:10 2014

@author: alkis
"""

from sympy import var, expand, lcm, LM, LT, reduced, monic
from sympy import groebner, solve_poly_system, solve, gcd, simplify

x, y = var('x y')


f1 = 2*x**2 - 4*x + y**2 - 4*y + 3
f2 = x**2 - 2*x + 3*y**2 - 12*y + 9

def s_polynomial(f, g):
    return expand(lcm(LM(f), LM(g))*(1/LT(f)*f - 1/LT(g)*g))


print("f1 = : ", f1," f2 = : ", f2)

print("L terms : ", LT(f1), LT(f2))
print("L monomials : ", LM(f1), LM(f2))
lcm1 = lcm(LM(f1), LM(f2))
print("LCM of monomials : ",lcm1)

print("lcm*f1 / LT(f1) : ", expand(lcm1*f1 / LT(f1)))
print("lcm*f2 / LT(f2) : ", expand(lcm1*f2 / LT(f2)))
print("lcm*f1 / LT(f1) - lcm*f2 / LT(f2) : ",
      expand(lcm1*f1 / LT(f1) - lcm1*f2 / LT(f2)))

s1 = s_polynomial(f1,f2)
print('s1 = ', s1)

F = [f1, f2]

f3 = reduced(s1, F)[1]
print(f3)

F.append(f3)

s1 = s_polynomial(f1,f2)

print(reduced(s1, F)[1])

s2 = s_polynomial(f1,f3)

print(reduced(s2, F)[1])

def buchberger(F, reduce=True):
    """Toy implementation of Buchberger algorithm. """
    G, pairs = list(F), set([])

    for i, f1 in enumerate(F):
        for f2 in F[i+1:]:
            pairs.add((f1, f2))

    while pairs:
        f1, f2 = pairs.pop()

        s = s_polynomial(f1, f2)
        _, h = reduced(s, G)

        if h != 0:
            for g in G:
                pairs.add((g, h))

            G.append(h)

    if reduce:
        GroebnerBasis = [0]*len(G)
        for i, g in enumerate(G):
            _, GroebnerBasis[i] = reduced(g, G[:i] + G[i+1:])
        GroebnerBasis = [i for i in GroebnerBasis if i != 0]

        GroebnerBasis = list(map(monic, GroebnerBasis))

    return GroebnerBasis

print('buchberger = ', buchberger([f1, f2]), '\n')
print("Sympy output")
basis = groebner([f1, f2], x, y, order='lex')
print('basis = ', basis, '\n')
