# -*- coding: utf-8 -*-
"""
Created on Fri Apr  4 23:19:10 2014

@author: alkis
"""

from sympy import var, expand, lcm, LM, LT, reduced, monic
from sympy import groebner, solve_poly_system, solve
from sympy.polys.groebnertools import s_poly

x, y, z = var('x y z')

# R, x,y,z = ring("x,y,z", QQ, lex)
# s_poly([], R)

def s_polynomial(f, g):
    return expand(lcm(LM(f), LM(g))*(1/LT(f)*f - 1/LT(g)*g))

def buchberger(F, reduce=True):
    """Toy Buchberger's algorithm. """
    G, pairs = list(F), set([])

    for i, f1 in enumerate(F):
        for f2 in F[i+1:]:
            pairs.add((f1, f2))
    
    while pairs:
        f1, f2 = pairs.pop()

        s = s_polynomial(f1, f2)
        _, h = reduced(s, G)

        if h != 0:
            for g in G:
                pairs.add((g, h))
            G.append(h)

        print('pairs = ', len(pairs))
        print('G = ', len(G))
    print('Length of GroebnerBasis BEFORE reduced = ', len(G))
    print('GroebnerBasis BEFORE reduced = ', G)

    if reduce:
        GroebnerBasis = [0]*len(G)
        for i, g in enumerate(G):
            _, GroebnerBasis[i] = reduced(g, G[:i] + G[i+1:])
        GroebnerBasis = [i for i in GroebnerBasis if i != 0]

        GroebnerBasis = list(map(monic, GroebnerBasis))
        print('Final length of GroebnerBasis = ', len(GroebnerBasis))
    else:
        GroebnerBasis = G

    return GroebnerBasis

f1 = 3*x**3*y + 5*x*y**6 + 2
f2 = x**5 + y**5 - 1

# f1 = x**2 - y
# f2 = x**3 - z

# f1 = x**3 - 2*x*y
# f2 = x**2*y - 2*y**2 + x

# f1 = 2*x**2 - 4*x + y**2 - 4*y + 3
# f2 = x**2 - 2*x + 3*y**2 - 12*y + 9

# f1 = x**2 - 3*y - x + 1
# f2 = y**2 - 2*x + y - 1


print('system solution', solve_poly_system([f1, f2], *[x, y]), '\n')


F = [f1, f2]

print("f1 = : ",f1," f2 = : ", f2, '\n')

# basis = buchberger(F, reduce=False)
# print('buchberger :: ', buchberger(F), '\n')


print("Sympy output", '\n')
basis = groebner(F, x, y,  order='grlex')
print('basis grlex = ', basis, '\n')

print('fglm conversion from grlex to lex ', list(basis.fglm('lex')), '\n')

basis = groebner(F, x, y,  order='lex')
print('basis lex= ', basis, '\n')

#######################################
## Discovering new geometrical formulae
#######################################

# discover a formula expressing the area of a triangle with sides a, b, c
# through its three heights h_a, h_b, h_c
A, a, b, c, p, ha, hb, hc = var('A, a, b, c, p, ha, hb, hc')
F = [2*A-a*ha, 2*A-b*hb,2*A-c*hc,
         A**2 - p*(p - a)*(p - b)*(p - c), 2*p - (a + b + c)]

basis = groebner(F, *[a, b, c, p, ha, hb, hc, A], order='lex')
print(len(basis), '\n')
print('triangle', basis, '\n')
area = basis[26]
print('last member of basis = ', area, '\n')
formula = area.subs({A**2 : x})
print('poly in x**2 :: ', formula, '\n')
print('Area of the triangle :: ', expand( solve(formula, x)[1]))




