from sympy import symbols
from sympy.core import Mul, Pow

def gen_monomials1(variables, degrees):
    monomials = [1]

    idx_degree = 0
    for variable in variables:
        new_monomials = []

        for degree in range(0, degrees[idx_degree] + 1):
            for monomial in monomials:
                new_monomials.append(Mul(monomial, Pow(variable, degree)))

        idx_degree += 1
        monomials = new_monomials
    
    return monomials


def gen_monomials2(variables, degrees):
    monomials = [1]

    for variable, degree in zip(variables, degrees):
        new_monomials = []

        for var_degree in range(0, degree + 1):
            for monomial in monomials:
                new_monomials.append(Mul(monomial, Pow(variable, var_degree)))

        monomials = new_monomials
    
    return monomials


def gen_monomials3(variables, degrees):
    monomials = [1]

    for variable, degree in zip(variables, degrees):
        new_monomials = []
        
        for var_degree in range(1, degree+1):
            for i in range(0, len(monomials)):
                new_monomials.append(Mul(monomials[i], Pow(variable, var_degree)))

        monomials += new_monomials
    
    return monomials


def gen_monomials4(variables, degrees):
    monomials = [1]

    for variable, degree in zip(variables, degrees):
        new_monomials = []
        
        for var_degree in range(1, degree+1):
            for monomial in monomials:
                new_monomials.append(Mul(monomial, Pow(variable, var_degree)))

        monomials += new_monomials
    
    return monomials


x, y, z = symbols('x y z')
#print("gen_monomials1([x,y], [3, 2]):", gen_monomials1([x,y], [3, 2]))
#print("gen_monomials2([x,y], [3, 2]):", gen_monomials2([x,y], [3, 2]))
#print("gen_monomials3([x,y], [3, 2]):", gen_monomials3([x,y], [3, 2]))
#print("gen_monomials4([x,y], [3, 2]):", gen_monomials4([x,y], [3, 2]))
import time
start_time = time.time()
monoms = gen_monomials3([x, y], [1, 2])
print("--- %s seconds ---" % (time.time() - start_time))
print('len_monomials_NEW = ', len(monoms), '\n')

print("\ngen_monomials3([x, y], [1, 2]): ", gen_monomials3([x, y], [1, 2]))