# Serafeim Karaiskos
# Alexandros Bistarakis
from sympy import symbols

def itermonomials_rec ( variables, max_degrees, min_degrees = None ):
    """
    Returns a list of all monomials such that
    min_degrees[i] <= degree_list(monom)[i] <= max_degrees[i]
    for all monom in the list and all i.
    
    If max_degrees = [d_1, ..., d_n] and min_degrees = [e_1, ..., e_n],
    the number of monomials in the list is:
    
                (d_1 - e_1 + 1) * ... * (d_n - e_n + 1)
    """
    # set min_degrees to zeros when None
    if min_degrees is None:
        min_degrees = [0]*len(max_degrees)
        
    # check length of arguments
    if (len(variables) != len(max_degrees) or len(variables) != len(min_degrees) ):
        raise ValueError('Argument size does not match')

    # min_degrees[i] <= max_degrees[i] for all i
    if sum([bool(min_degrees[i] <= max_degrees[i])
                    for i in range(len(variables))]) != len(variables):
        raise ValueError('min_degrees[i] must be <= max_degrees[i] for all i.')

    mon1 = [variables[0]**x for x in range(min_degrees[0], max_degrees[0] + 1)]
    # terminating case
    if (len(variables)==1):
        return mon1
    # result
    return [x*y for x in mon1
                    for y in itermonomials_rec( 
                                    variables[1:], 
                                    max_degrees[1:], 
                                    min_degrees[1:])]

def itermonomials_iter ( variables, max_degrees, min_degrees = None ):
    """

    """
    # set min_degrees to zeros when it is not given
    if min_degrees is None:
        min_degrees = [0]*len(max_degrees)
    # check the length of arguments
    if (len(variables) != len(max_degrees) or len(variables) != len(min_degrees) ):
        raise ValueError("Argument size does not mach")

    
    result = [1]
    for i in range(len(variables)):
        result = [ y*(variables[i]**p) 
                    for p in range(min_degrees[i], max_degrees[i] + 1)
                        for y in result ]
    return result

x,y,z = symbols('x y z')
variables = [x,y,z]

import time
start_time = time.time()

#mon = itermonomials_rec ( variables, [3, 2, 1])
#print("--- %s seconds ---" % (time.time() - start_time))
#print('len_monomials_NEW = ', len(mon), '\n')

#print( "rec-- len = {}, monomials:{}".format(len(mon), mon))
#print(len(itermonomials_rec ( variables, [1,2,3] )))

mon = itermonomials_iter ( variables, [3, 2, 1])
print("--- %s seconds ---" % (time.time() - start_time))
print('len_monomials_NEW = ', len(mon), '\n')
#print( "iter-- len = {}, monomials:{}".format(len(mon), mon))
#print(len(itermonomials_rec ( variables, [1,2,3] )))