# Charalampos Tsiagkalis

from itertools import product
from sympy.core import Mul


def itermonomials_degree_list(variables, max_degrees, min_degrees=None):
    """
    Returns a list of all monomials such that
    min_degrees[i] <= degree_list(monom)[i] <= max_degrees[i]
    for all monom in the list and all i.
    
    If max_degrees = [d_1, ..., d_n] and min_degrees = [e_1, ..., e_n],
    the number of monomials in the list is:

                (d_1 - e_1 + 1) * ... * (d_n - e_n + 1)
    """
    # set min_degrees to zeros when None
    if min_degrees is None:
        min_degrees = [0] * len(max_degrees)

    # check length of arguments
    if (len(variables) != len(max_degrees) or len(variables) != len(min_degrees) ):
        raise ValueError('Argument size does not match')

    # min_degrees[i] <= max_degrees[i] for all i
    if sum([bool(min_degrees[i] <= max_degrees[i])
                    for i in range(len(variables))]) != len(variables):
        raise ValueError('min_degrees[i] must be <= max_degrees[i] for all i.')

    # {x: [min_degree_x, max_degree_x], y: [min_degree_y, max_degree_y], ...}
    variables_dict = {v[0]:list(v[1:]) for v in zip(variables,min_degrees,max_degrees)}

    monomials_list = []
    for variable in variables_dict.keys():
        # monomials of single variables
        current_var_list = []
        for power in range(variables_dict[variable][0], variables_dict[variable][1]+1):
            current_var_list.append(variable**power)
        monomials_list.append(current_var_list)

    return [Mul(*mon) for mon in product(*monomials_list)]



#from sympy import symbols

#x,y,z = symbols('x, y, z')

from sympy.abc import x, y, z

import time
start_time = time.time()

from sympy.polys.orderings import monomial_key

monomials = sorted(itermonomials_degree_list([x, y], [2, 4], [1, 2]), 
                  reverse=True, key=monomial_key('lex', [x, y]))
print("--- %s seconds ---" % (time.time() - start_time))

print("Number of monomials: ", len(monomials))
print("Monomials: ", monomials)
        
