// By: Bektasiadis Efstratios

#ifndef _FUNCTIONS_H_
#define _FUNCTIONS_H_

book insertBook(int total_books){
void viewBooks(int total_books, book bookshelf[]);

user addUser();
void viewUsers(int tUsers, user uDB[], book books[]);

int searchByUsername(user u[], int tUsers, char name[]);
int searchByBookName(book b[], int tBooks, char name[]);

user* borrowBook(user users[], book books[], int tUsers, int tBooks);

void viewBooks(int total_books, book bookshelf[]){
  int i;
  for(i=0; i < total_books; i++){
    printf("Title: %s\nPages: %d\nRating: %d\nVersion: %d\n\n", bookshelf[i].name, bookshelf[i].pages, bookshelf[i].rating, bookshelf[i].version);
  }
}

void viewUsers(int tUsers, user uDB[], book books[]){
  int i;
  for(i=0; i < tUsers; i++){
    printf("User: %s\n", uDB[i].name);
    if(uDB[i].borrowed >= 0){
      printf("\tBorrowed: %s\n", books[uDB[i].borrowed].name);
    }
  }
}

user addUser(){
  user u;
  fgets(u.name, sizeof(u.name), stdin);
  u.name[strlen(u.name)-1] = '\0';
  u.borrowed = -1;
  return u;
}

book insertBook(int total_books){
  book b;
  fgets(b.name, sizeof(b.name), stdin);
  int book_length = strlen(b.name);
  b.name[book_length-1] = '\0';
  scanf("%d", &b.pages);
  scanf("%d", &b.rating);
  scanf("%d", &b.version);
  b.id = total_books;
  return b;
}

int searchByUsername(user u[], int tUsers, char name[]){
  int pos;
  for(pos=0; pos < tUsers; pos++){
    if(strcmp(name,u[pos].name) == 0){
      return pos;
    }
  }
  return -1;
}

user* returnBook(user users[], int tUsers){
  char target_user_name[50];
  printf("Username?\n");
  fgets(target_user_name, 50, stdin);
  target_user_name[strlen(target_user_name)-1] = '\0';
  int userPos = searchByUsername(users, tUsers, target_user_name);
  users[userPos].borrowed = -1;
  return users;
}

int searchByBookName(book b[], int tBooks, char name[]){
  int pos;
  for(pos=0; pos < tBooks; pos++){
    if(strcmp(name,b[pos].name) == 0){
      return b[pos].id;
    }
  }
  return -1;
}

user* borrowBook(user users[], book books[], int tUsers, int tBooks){
  char target_book_name[50], target_user_name[50];
  printf("Username and bookname?\n");
  fgets(target_user_name, 50, stdin);
  fgets(target_book_name, 50, stdin);
  target_book_name[strlen(target_book_name)-1] = '\0';
  target_user_name[strlen(target_user_name)-1] = '\0';

  int userPos = searchByUsername(users, tUsers, target_user_name);
  if(userPos < 0){
    printf("User can't be found.\n");
    return users;
  }

  int bookId = searchByBookName(books, tBooks, target_book_name);
  if(bookId < 0){
    printf("Book can't be found.\n");
    return users;
  }

  users[userPos].borrowed = bookId;
  return users;
}

#endif
