function s=traprl(f,a,b,M)
%Input    - f is the integrand input as a string 'f'
%         - a and b are upper and lower limits of integration
%         - M is the number of subintervals
%Output   - s is the trapezoidal rule sum

h=(b-a)/M;
fprintf('h=%4.8f\n', h);
fprintf('=============\n')
s=0;

y0=feval(f,a);
fprintf('y0=%4.8f\n', y0);

for k=1:(M-1)
   x=a+h*k;
   y=feval(f,x);
   fprintf('y%d=%4.8f\n', k, y);
   s=s+y;
end

yn=feval(f,b);
fprintf('yn=%4.8f\n', yn);
fprintf('=============\n')

s=h*(y0+yn)/2+h*s;
fprintf('I=%4.8f\n', s);
fprintf('=============\n')
