function s=simprl(f,a,b,M)
%Input    - f is the integrand input as a string 'f'
%         - a and b are upper and lower limits of integration
%         - M is the number of subintervals
%Output   - s is the simpson rule sum

h=(b-a)/(2*M);
fprintf('h=%4.8f\n', h);
s1=0;
s2=0;

for k=1:M
   x=a+h*(2*k-1);
   fprintf('S%d=%4.8f\n', 2*k-1, feval(f,x));
%   fprintf('%4.8f\n', feval(f,x));
   s1=s1+feval(f,x);
end
for k=1:(M-1)
   x=a+h*2*k;
   fprintf('S%d=%4.8f\n', 2*k, feval(f,x));
%   fprintf('%4.8f\n', feval(f,x));
   s2=s2+feval(f,x);
end

fprintf('S0=%4.8f\n', feval(f,a));
fprintf('S%d=%4.8f\n', 2*M, feval(f,b));

s=h*(feval(f,a)+feval(f,b)+4*s1+2*s2)/3
