%{
    A demonstration of sliding_window function usage
%}
% Read an image
clc;
clear all;
image = imread('house.jpg');
image2 = imread('house2.jpg');
% Convert it to gray scale
image = double(rgb2gray(image));
image2 = double(rgb2gray(image2));
% Define the width and height of the window
window_width = 200;
window_height = 200;
% Define the stride
window_stride = 50;
% Define feature extraction functions
mean_function = @(im)mean2(im);
% Here we utilize the LBP feature extraction function of matlab with cell
% size 20
lbp_function = @(im)extractLBPFeatures(uint8(im),'Upright',false,'CellSize',[20 20]);
% We call the sliding_window function to extract N windows 
[features,positions] = sliding_window(image,window_width,window_height,window_stride,lbp_function);
[features2,positions2] = sliding_window(image2,window_width,window_height,window_stride,lbp_function);
% For the lbp_function we would like to compare the LBP histograms of 2
% images
figure('Name','house.jpg','NumberTitle','off');
d = ceil(sqrt(size(features,2)));
for i = 1:size(features,2)
    subplot(d,d,i);
    histogram(features{i});
    title(sprintf('Window %d',i));
end
figure('Name','house2.jpg','NumberTitle','off');
d = ceil(sqrt(size(features2,2)));
for i = 1:size(features2,2)
    subplot(d,d,i);
    histogram(features2{i});
    title(sprintf('Window %d',i));
end


