function [retValue, positions]= sliding_window(image,window_width,window_height,stride,func)
    % An general purpose sliding window algorithm implementation
    image_height = size(image,1);
    image_width = size(image,2);
    % This is a "cell array" effectively it allows us to append arrays of
    % different sizes. We can access a cell array using {index} notiation
    retValue = {};
    positions = {};
    for i = 1 :stride:image_height-window_height  
        for j = 1:stride:image_width-window_width 
            to_h = i+window_height-1;
            to_w = j+window_width-1;
            w = image(i:to_h,j:to_w);
            m = func(w);
            retValue{end+1} = m;
            positions{end+1} = [i,j,to_h,to_w];
            %image(i:min(image_height,i+window_height),j:min(image_width,j+window_width)) = w.*mean(w);
            %image(i,:) =255; 
            %image(:,j) =255; 
        end
    end
end