function out = rgb2i1i2i3(rgb)
    % RGB2I1I2I3 converts image RGB from RGB to I1I2I3 colorspace
    tm = [
        1/3, 1/3, 1/3; 
        1/2, 0, -1/2; 
        -1/4, 1/2, -1/4
    ]; 
    % transformation matrix
    [w h c] = size(rgb);
    rgb = reshape(im2double(rgb), [], c)';
    % normalize to [0 1]
    out = (reshape((tm*rgb)', w, h, c)+1)/2; 