%{
    In this example we will examine the K nearest neighbor classifier 
    For this reason we are going to load a dataset with named: "fisheriris" 
%}
clear all;
clc;
load fisheriris;
% X represents the featured vectors
X = meas;

% Y represents the classes
Y = species;

% It is always helpful to have a closer look to our data

x = X(:,3:4);
%gscatter(x(:,1),x(:,2),species);
%legend('Location','best');


% we must figure out the number of neighnbors 
numNeightbors = size(unique(Y),1);
% we are now ready to build our model
model = fitcknn(X,Y,'NumNeighbors',numNeightbors,'Standardize',1);

% we can now get some details about the model that we just trained
% Let's get the names of our classes
disp(model.ClassNames);

% lets predict labels for all of our X vectors
for vector = 1:size(X,1)
    [label,score,cost] = predict(model,X(vector,:));
    fprintf('Vector %d has label %s\n',vector,label{1})
end

% We can also examine the performance of our trained model
predictions = model.predict(X);
actual = Y;
performanceData = classperf(Y,predictions)
% Let's calculate the Confusion Matrix
disp('The Confusion Matrix is:');
confusionMatrix = confusionmat(actual,predictions)
% Matlab provides a method named: confusionchart, that allows us to plot
% the confusion matrix. Unfortunately this is only available in Matlab2018b
% confusionchart(confusionMatrix);
% An easy work around would be to display the confusion matrix as a colored
% image using the imagesc function and attaching a colorbar
figure
imagesc(confusionMatrix)
colorbar;

% To evaluate our classifier it would be beneficial to perform a 10-fold
% cross validation. That means we keep 10% of our data for testing and we
% will train our classifier with the rest 90%. We will perform this
% operation 10 times, each time selecting a different sample of data from
% the dataset.

folds = 10;
cvmdl = crossval(model,'KFold',folds);
% Let's now calculate the error rate
loss = kfoldLoss(cvmdl);
disp('10-fold cross validation results: ');
disp(loss);
disp('which translates to under 5% error rate in our classification');




