%{
    Image histogram quantization
    Demonstrates the effect of different quanta selection
    quantas used: [128,64,32,16,8]
%}

clc;
clear all;

image = imread('house.jpg');
image = rgb2gray(image);
figure;
subplot(3,4,1);
imshow(image);
title('Original');
subplot(6,4,2);
histogram(image);
image = double(image) / 255;

subplot(3,4,3);
quanta = 128;
q128 = uint8(image * quanta);
q128 = double(q128) / quanta;

imshow(q128);
title('Quanta = 128');
subplot(3,4,4);
histogram(q128*255);

subplot(3,4,5);
quanta = 64;
q64 = uint8(image * quanta);
q64 = double(q64) / quanta;
imshow(q64);
title('Quanta = 64');
subplot(3,4,6);
histogram(q64*255);

subplot(3,4,7);
quanta = 32;
q32 = uint8(image * quanta);
q32 = double(q32) / quanta;
imshow(q32);
title('Quanta = 32');
subplot(3,4,8);
histogram(q32*255);

subplot(3,4,9);
quanta = 16;
q16 = uint8(image * quanta);
q16 = double(q16) / quanta;
imshow(q16);
title('Quanta = 16');
subplot(3,4,10);
histogram(q16*255);

subplot(3,4,11);
quanta = 8;
q8 = uint8(image * quanta);
q8 = double(q8) / quanta;
imshow(q8);
title('Quanta = 8');
subplot(3,4,12);
histogram(q8*255);


