%{
    Manual: 
    * https://www.mathworks.com/help/vision/ref/detectharrisfeatures.html
%}
clc;
clear all;
% Load an RGB image named "house.jpg" from the working directory
image = imread('house.jpg'); 
% To extract corner points using the Harris method we must firstly convert
% our RGB image to grayscale. We do that using the rgb2gray(image) method
imageGray = rgb2gray(image);
% We can now use the detectHarrisFeatures method
cornerPoints = detectHarrisFeatures(imageGray);
subplot(2,1,1);
% We can show now the image
imshow(imageGray); 
title('Default - MinQuality: 0.01 and FilterSize: 5x5');
% hold it so we can plot in the figure
hold on;
% plot the "strongest" points on the image using the "plot" function
plot(cornerPoints.selectStrongest(100));
hold off;


% We can also define the filter size and the threshold value of the
% corners.

subplot(2,1,2);
cornerPoints = detectHarrisFeatures(imageGray,'MinQuality',0.05, 'FilterSize',3);
% We can show now the image
imshow(imageGray); 
title('MinQuality: 0.05 and FilterSize: 3x3');
% hold it so we can plot in the figure
hold on;
% plot the "strongest" points on the image using the "plot" function
plot(cornerPoints.selectStrongest(100));
hold off;
