% Let's examine varius color spaces
% Initially we will see the Red Green and Blue channels of an RGB image
clc;
clear all;
image = imread('house.jpg');
figure('Name','RGB color space','NumberTitle','off');
subplot(3,3,2);
imshow(image);
title('Original');
% Red channel
r = image(:,:,1); 
% Green channel
g = image(:,:,2); 
% Blue channel
b = image(:,:,3);
% create a black image
black = zeros(size(image, 1), size(image, 2), 'uint8');
% Create color versions of the individual color channels.
red = cat(3, r, black, black);
green = cat(3, black, g, black);
blue = cat(3, black, black, b);
% We can now plot them
subplot(3,3,4);
imshow(red);
title('Red');
subplot(3,3,5);
imshow(green);
title('Green');
subplot(3,3,6);
imshow(blue);
title('Blue');

subplot(3,3,7);
imhist(r);
subplot(3,3,8);
imhist(g);
subplot(3,3,9);
imhist(b);



%-----------------------------%
%            HSV              %
%-----------------------------%
figure('Name','HSV color space','NumberTitle','off');
subplot(3,3,2);
imshow(image);
hsvImage = rgb2hsv(image);
title('Original');
% H channel
h = hsvImage(:,:,1); 
% S channel
s = hsvImage(:,:,2); 
% V channel
v = hsvImage(:,:,3);
% We can now plot them
subplot(3,3,4);
imshow(mat2gray(255*h));
title('Hue');

subplot(3,3,5);
imshow(mat2gray(255*s));
title('Saturation');

subplot(3,3,6);
imshow(mat2gray(255*v));
title('Value - lightness');

subplot(3,3,7);
imhist(h);
subplot(3,3,8);
imhist(s);
subplot(3,3,9);
imhist(v);
%-----------------------------%
%          CIE-LAB            %
%-----------------------------%
figure('Name','CIE-LAB color space','NumberTitle','off');
subplot(3,3,2);
imshow(image);
labImage = rgb2lab(image);
title('Original');
% L channel
l = labImage(:,:,1); 
% A channel
a = labImage(:,:,2); 
% B channel
b = labImage(:,:,3);
% We can now plot them
subplot(3,3,4);
imshow(mat2gray(255*l));
title('L channel');
subplot(3,3,5);
imshow(mat2gray(255*a));
title('A channel');
subplot(3,3,6);
imshow(mat2gray(255*b));
title('B channel');
subplot(3,3,7);
histogram(l);
subplot(3,3,8);
histogram(a);
subplot(3,3,9);
histogram(b);


%-----------------------------%
%           I1I2I3            %
%-----------------------------%
figure('Name','I1I2I3 color space','NumberTitle','off');
subplot(3,3,2);
imshow(image);
i1i2i3Image = rgb2i1i2i3(image);
title('Original');
% I1 channel
i1 = i1i2i3Image(:,:,1); 
% I2 channel
i2 = i1i2i3Image(:,:,2); 
% I3 channel
i3 = i1i2i3Image(:,:,3);
% We can now plot them
subplot(3,3,4);
imshow(mat2gray(255*i1));
title('I1');

subplot(3,3,5);
imshow(mat2gray(255*i2));
title('I2');

subplot(3,3,6);
imshow(mat2gray(255*i3));
title('I3');
subplot(3,3,7);
imhist(i1);
subplot(3,3,8);
imhist(i2);
subplot(3,3,9);
imhist(i3);