% Clear screen
clc;
% Clear workspace variables
clear;

% In this example we are going to demonstrate the creation and usage of
% arrays. Afterall, MATLAB name comes from...MATRIX LABORATORY!

% Let's create a vector (1D array) with values 0..100
aVector = [0:100];
% Now let's loop within the values of the vector and print them
for value = aVector
    disp(value);
end
% We can also loop using a while loop
i = 1;
while i<100
    disp(aVector(i));
    i = i+1;
end

% Let's now create a vector with all the even values from 0 to 100
aVector = [0:2:100];
% Now let's print some of the values
for index = [10:14]
    disp(sprintf("Value of aVector(%d) = %d",index,aVector(index)));
end

% Let's examine a more interesting form of vectors which is where MATLAB
% is performing great
% Let's create a vector with values = sin(x)
aVector = sin([0:0.1:1]);
length = numel(aVector)
for index = [1:length]
    sprintf("sin(%.1f) = %.3f",index-1,aVector(index))
end

% Now we want to select just the first 5 elements of this vector
aNewVector = aVector(1:5);
disp(aNewVector);
% If we want to skip the first 3 elements and select the rest we would do
aNewVector = aVector(4:end);
disp(aNewVector);
% If we want to select just the odd elements
aNewVector = aVector(1:2:end);
disp(aNewVector);
% We can also define column vectors
aColumnVector = [1;2;3];
disp(aColumnVector);
% If we want to generate a column vector with values 0 .. 100 we would do
% The "'" notiation produces the transposed value of an array
aColumnVector0_100 = [0:100]';
disp(aColumnVector0_100);
% There are many ways to retrieve the size of an array
% size: Returns the number of rows and the number of columns of an array
size_of_aColumnVector0_100 = size(aColumnVector0_100);
disp(size_of_aColumnVector0_100);
% we can even sort them!
sorted_of_aColumnVector0_100 = sort(aColumnVector0_100,'descend');
disp(sorted_of_aColumnVector0_100);
% max, min and average! 
max_min_and_average_of_aColumnVector0_100 = [max(aColumnVector0_100), min(aColumnVector0_100),mean(aColumnVector0_100)];
disp(max_min_and_average_of_aColumnVector0_100);
