% We are going to demonstrate simple mathematical operations between
% variables.
x = 5;
y = 10;

% let's get the type of the variable x
class(x)
% let's test that in fact, x is a double!
disp('Is x a double?: ');
isa(x,'double')
% Here we utilize the function "sprintf" to format a string
% %d is used as placeholder for integer values
formattedString = sprintf('%d + %d = %d',x,y,x+y);
disp(formattedString);

formattedString = sprintf('%d - %d = %d',x,y,x-y);
disp(formattedString);

formattedString = sprintf('%d * %d = %d',x,y,x*y);
disp(formattedString);

% %f is used as placeholder for double values
formattedString = sprintf('%d / %d = %f',x,y,x/y);
disp(formattedString);

% Let's format it a bit better
formattedString = sprintf('%d / %d = %.3f',x,y,x/y);
disp(formattedString);

formattedString = sprintf('%d ^ %d = %.3f',x,y,x^y);
disp(formattedString);

formattedString = sprintf('sin(%0.3f) = %.3f',x,sin(x));
disp(formattedString);

formattedString = sprintf('cos(%0.3f) = %.3f',x,cos(x));
disp(formattedString);

formattedString = sprintf('tan(%0.3f) = %.3f',x,tan(x));
disp(formattedString);