function [out] = myconv2d(image,kernel)
    % A custom implementation of conv2d function
    [kernel_rows,kernel_cols] = size(kernel);
    [image_rows,image_cols] = size(image);
    % rotate the kernel by 180 degrees
    rotated_kernel = rot90(kernel, 2);
    % compute the center of the kernel 
    kernel_center = floor((size(rotated_kernel)+1)/2);
    left = kernel_center(2) - 1;
    right = kernel_cols - kernel_center(2);
    top = kernel_center(1) - 1;
    bottom = kernel_rows - kernel_center(1);
    % pad the image (add zeros around it)
    padded_image = zeros(image_rows + top + bottom, image_cols + left + right);
    % fill the padded image with the real image in the center
    for x = 1 + top : image_rows + top
        for y = 1 + left : image_cols + left
            padded_image(x,y) = image(x - top, y - left);
        end
    end
    out = zeros(image_rows , image_cols);
    for x = 1 : image_rows
        for y = 1 : image_cols
            for i = 1 : kernel_rows
                for j = 1 : kernel_cols
                    q = x - 1;
                    w = y -1;
                    out(x, y) = out(x, y) + (padded_image(i + q, j + w) * rotated_kernel(i, j));
                end
            end
        end
    end
    imshow(uint8(out));
end
