clc;
clear;
% To load an image into matlab worstation we call the function imread.
image = imread('lena.jpg');
% Let's firstly display the image
figure;
imshow(image)
title("Original Image");
% Image is an array of height width channels
size(image)
height = size(image,1);
width = size(image,2);
% Let's split the channels of the image into red, green and blue
redChannel = image(:,:,1);
greenChannel = image(:,:,2);
blueChannel = image(:,:,3);

allBlack = zeros(height,width, 'uint8');
% build the red channel 
redImage = cat(3,redChannel,allBlack,allBlack);
% build the green channel 
greenImage = cat(3,allBlack,greenChannel,allBlack);
% build the blue channel 
blueImage = cat(3,allBlack,allBlack,blueChannel);
% We can also create a gray scale image
grayscaleImage = rgb2gray(image);

% we would like to display all the images in one figure so
figure;
axes = subplot(2,3,1);
imshow(image);
title(axes,"Original Image");
axes = subplot(2,3,3);
imshow(grayscaleImage);
title(axes,"Grayscale Image");
axes = subplot(2,3,4);
imshow(redImage);
title(axes,"Red Channel");
axes = subplot(2,3,5);
imshow(greenImage);
title(axes,"Green Channel");
axes = subplot(2,3,6);
imshow(blueImage);
title(axes,"Blue Channel");

% Some more complex operations
% Scale down the image 

scaledDown = imresize(image,0.3);
% Scale up the image 
scaledUp = imresize(image,2);
% Translate
translated = imtranslate(image,[50,50]);
% rotate
rotated = imrotate(image,30);
% vertical flip
verticalFlipped = flipud(image);
% horizontal flip
horizontalFlipped = fliplr(image);
figure; 
axes = subplot(2,3,1);
imshow(scaledDown);
title(axes,"Scale down by 70%");
axes = subplot(2,3,2);
imshow(scaledUp);
title(axes,"Scale up by 2x");
axes = subplot(2,3,3);
imshow(translated);
title(axes,"Translated by 50x50");
axes = subplot(2,3,4);
imshow(rotated);
title(axes,"Rotated by 30");
axes = subplot(2,3,5);
imshow(verticalFlipped);
title(axes,"Flip vertical");
axes = subplot(2,3,6);
imshow(horizontalFlipped);
title(axes,"Flip horizontal");

% More complex!
figure;
binary  = im2bw(grayscaleImage,.5);
quantized  = label2rgb(imquantize(grayscaleImage,multithresh(grayscaleImage,10)));
adjusted = imadjust(grayscaleImage);
histogramEqualized = histeq(image);

axes = subplot(2,3,1);
imshow(binary);
title(axes,"Binary threshold .5");
axes = subplot(2,3,2);
imshow(quantized);
title(axes,"Quantized");
axes = subplot(2,3,3);
imshow(binary);
title(axes,"Adjusted");
axes = subplot(2,3,4);
imshow(adjusted);
title(axes,"Equalized");
axes = subplot(2,3,5);
imhist(histogramEqualized);
title(axes,"RGB histogram");
axes = subplot(2,3,6);
imhist(grayscaleImage);
title(axes,"Grayscale histogram");

% Let's save the red channel!
imwrite(redImage,'red.jpg')

