clc;
clear;
% sobel-y --> [ 1   2   1]
%             [ 0   0   0]
%             [-1  -2  -1]

% sobel-x -->  [1  0 -1]
%              [2  0 -2]
%              [1  0 -1] 

% To load an image into matlab worstation we call the function imread.
image = imread('lena.jpg');
% To simplify our experiments we are going to convert the image to
% grayscale
image = rgb2gray(image);
% The convolution operation can be performed on a 2D array using the
% function call "conv2" which takes as first argument the image and as the
% second the mask
% as we want to apply mathimatical operation to the image 
% we have to convert it into a double matrix
imaged = double(image);

% Mean filter
mean = double(ones(3,3)).*(1/9);
meanImage = conv2(imaged,mean);
% Finding edged 1st order (roberts1) 
roberts1 = double([-1 0; 0 1]);
roberts1Image = conv2(imaged,roberts1);
% Finding edged 1st order (roberts2) 
roberts2 = double([0 -1; 1 0]);
roberts2Image = conv2(imaged,roberts2);

% Finding edged 1st order (prewitt1) 
prewitt1 = double([-1 -1 -1; 0 0 0; 1 1 1]);
prewitt1Image = conv2(imaged,prewitt1);
% Finding edged 1st order (prewitt2) 
prewitt2 = double([-1 0 1; -1 0 1; -1 0 1]);
prewitt2Image = conv2(imaged,prewitt2);

% Finding edged 1st order (sobelX) 
sobelX = double([1 0 -1; 2 0 -2; 1 0 -1]);
sobelXImage = conv2(imaged,sobelX);
% Finding edged 1st order (sobelY) 
sobelY = double([1 2 1; 0 0 0; -1 -2 -1]);
sobelYImage = conv2(imaged,sobelY);

% Sobel-X and Sobel-Y combined
sobelYX = sqrt((sobelXImage.^2)+(sobelYImage.^2));
sobelYXImage = sobelYX;%conv2(imaged,sobelYX);
imshow(uint8(sobelYXImage));

% Finding edged 2nd order (laplasian) 
laplasian = double([1 1 1; 1 -8 1; 1 1 1]);
laplasianImage = conv2(imaged,laplasian);

% Oksinsi - Auksisi twn akmwn tis eikonas me skopo na tin kanoyme na fenete
% katharoteri
oksinsi = [0 -1 0; -1 5 -1; 0 -1 0];
oksimeniEikona = conv2(imaged,double(oksinsi));

% Smoothing with gausian matrix 
z = fspecial('gaussian', [15 15], 1);
gaussianImage = conv2(imaged,double(z));
