image = imread('periodic.jpg');
image = double(rgb2gray(image));
alpha = 0.06;


% init gaussian filter for window function
% we have more drastic gaussian filter for quadratic intensities
gaussian = fspecial('Gaussian',[25 25],1);
deep_gaussian = fspecial('Gaussian',[25 25],2);

% Filter the image in both the x and y directions, 
% will handle the edge case later 
[gradient_X, gradient_Y] = gradient(gaussian);
Ix = imfilter(image, gradient_X);
Iy = imfilter(image, gradient_Y);

% Get ixx, iyy, ixy for the calculation of various intensities
Ixx = imfilter(Ix .* Ix, deep_gaussian);
Iyy = imfilter(Iy .* Iy, deep_gaussian);
Ixy = imfilter(Ix .* Iy, deep_gaussian);

% Formulate the corner response function to speedup detection
R = Ixx .* Iyy - Ixy .* Ixy - alpha*(Ixx + Iyy).^2;

% Show R as an image
figure;
Rn = normImage(R);
imshow(Rn);

% Detect maxima
[y, x] = find(Rn > 200);

% Plot image with maxima overlayed
figure;
imshow(image,[]);
hold on;
plot(x,y,'o');

