% A DIP example by D.K. Iakovidis
% Feature extraction using sliding window

% Load image
image = imread('bricks.jpg');

% Split channels
R = image(:,:,1);
G = image(:,:,2);
B = image(:,:,3);

rows = size(image,1);
columns = size(image,2);

% Acquire samples and extract features
windowSize = 32;
rowsLimit = rows-windowSize;
columnsLimit = columns-windowSize;
step = windowSize;

descriptors = [];
for i = 1:step:rowsLimit
    for j = 1:step:columnsLimit
        roiR = R(i:i+windowSize, j:j+windowSize);
        roiG = G(i:i+windowSize, j:j+windowSize);
        roiB = B(i:i+windowSize, j:j+windowSize);

	  % Extract mean RGB features
        meanR = mean(mean(roiR));
        meanG = mean(mean(roiG));
        meanB = mean(mean(roiB));
        vector = [meanR meanG meanB];
        descriptors = [descriptors; vector];
    end;
end;

xlswrite('descriptors.xls', descriptors);

