% A DIP example by D.K. Iakovidis
% Coccurrence matrix

clear all;

% Load image
image = imread('bricks.jpg');
image = rgb2gray(image);
greylevels = 256;

% Show image
imshow(image);
title('Original image');

rows = size(image,1);
columns = size(image,2);

% Initialize cooccurrence
cooc = zeros(greylevels, greylevels);

% Coccurrence 0 degrees
for k=1:rows
    for l=1:columns-1
        x = image(k,l)+1; % +1 because matrices in matlab begin at (1,1)
        y = image(k,l+1)+1;
        cooc(x,y) = cooc(x,y) + 1;
    end
end

% Display cooccurrence
figure;
imshow(cooc,[]); % may not be displayed nicely if large differences

% Cooccurrence as a feature vector
vector = reshape(cooc,1,greylevels*greylevels)

% Visualize descriptor
figure;
plot(vector);


